/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbdripper.recipe;

import com.mojang.brigadier.StringReader;
import dev.ftb.mods.ftbdripper.recipe.FTBDripperRecipeSerializers;
import dev.ftb.mods.ftbdripper.recipe.NoInventory;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DripRecipe
implements Recipe<NoInventory> {
    private final ResourceLocation id;
    private final String group;
    private String inputString;
    private Block input;
    private Map<Property<?>, Comparable<?>> inputProperties;
    public ItemStack inputItem;
    private String outputString;
    public BlockState output;
    public ItemStack outputItem;
    public Fluid fluid;
    public double chance;

    public DripRecipe(ResourceLocation i, String g) {
        this.id = i;
        this.group = g;
        this.inputString = "";
        this.input = Blocks.f_50016_;
        this.inputProperties = Collections.emptyMap();
        this.inputItem = ItemStack.f_41583_;
        this.outputString = "";
        this.output = Blocks.f_50016_.m_49966_();
        this.outputItem = ItemStack.f_41583_;
        this.fluid = Fluids.f_76193_;
        this.chance = 1.0;
    }

    public void setInputString(String s) {
        this.inputString = s;
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(this.inputString), false).m_116806_(false);
            this.input = Objects.requireNonNull(parser.m_116808_()).m_60734_();
            this.inputProperties = parser.m_116764_();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.input = Blocks.f_50016_;
            this.inputProperties = Collections.emptyMap();
        }
        if (this.inputItem.m_41619_()) {
            this.inputItem = this.input.m_5456_().m_7968_();
        }
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setOutputString(String s) {
        this.outputString = s;
        try {
            BlockStateParser parser = new BlockStateParser(new StringReader(this.outputString), false).m_116806_(false);
            this.output = Objects.requireNonNull(parser.m_116808_());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.output = Blocks.f_50016_.m_49966_();
        }
        if (this.outputItem.m_41619_()) {
            this.outputItem = this.output.m_60734_().m_5456_().m_7968_();
        }
    }

    public String getOutputString() {
        return this.outputString;
    }

    public boolean testInput(BlockState state) {
        if (this.input == Blocks.f_50016_ || this.input != state.m_60734_()) {
            return false;
        }
        for (Map.Entry<Property<?>, Comparable<?>> entry : this.inputProperties.entrySet()) {
            if (state.m_61143_(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matches(NoInventory inv, Level world) {
        return true;
    }

    public ItemStack assemble(NoInventory inv) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public RecipeSerializer<?> m_7707_() {
        return FTBDripperRecipeSerializers.DRIP.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FTBDripperRecipeSerializers.DRIP_TYPE.get();
    }
}

